{if $showupdst}{include file='partUpdPage.tpl'}{/if}
{include file="partMessage.tpl"}

<div class="card" id="wdgCustomDomainsModify">
    <div class="card-header">
        <h4>{if $editMode}Edit{else}Add{/if} Custom Domain</h4>
    </div>
    <div class="card-body">
        <p>Custom Tracking Domains can be associated to your CPV Lab instance and used in tracking links and Postback URLs.</p>
        <p>These are a great way of having your tracking links share the same root domain as the landing pages. This can be achieved by using a subdomain from your landing page domain as a Custom Trackign Domain.</p>
        <p>Complete details about setting up Custom Tracking Domains and the DNS configuration can be found in <a href="https://doc.cpvlab.pro/custom-tracking-domains.html" target="_blank">our Online Documentation</a>.</p>
        {if $domainsLimit>0}<p>Your license allows up to {$domainsLimit} Custom Tracking Domains to be used.</p>
        {else}<p class="profitRed font-weight-bold">The Started plan doesn't allow setting up Custom Tracking Domains. Please <a href="https://cpvlab.pro/pricing.php?utm_source=starter-domains" target="_blank" class="font-weight-bold">upgrade your plan</a> in order to use this feature.</p>
        {/if}
        <div class="row mt-4">
            <div class="col-xl-6 col-lg-8 col-md-12">
                <div class="form-group mb-4">
                    <label>Name</label>
                    <input type="text" name="txtCustomDomain" id="txtCustomDomain" class="form-control"
                        value="{$currentDomain|default:''}" />
                </div>
                <button name="ajax-test-domains" onclick="return ajaxTestCustomDomains(event)"
                    class="btn btn-primary mr-3"{if $showupdst} disabled="disabled"{/if}>Test Domain</button>
                <button name="btnSave_x" onclick="return validateName('txtCustomDomain', 'Custom Domains')"
                    class="btn btn-primary mr-3"{if $showupdst} disabled="disabled"{/if}>Save</button>
                {if $editMode}
                    <button name="btnCancel" onclick="window.location.href = 'custom-domains.php'; return false"
                        class="btn btn-secondary">Cancel</button>
                {/if}
            </div>
        </div>
    </div>
</div>

<div class="card" id="wdgCustomDomainsCurrent">
    <div class="card-header">
        <h4>Current Custom Domains</h4>
    </div>
    <div class="card-body">
        <table id="tblCustomDomains" class="{$theme_table_classes} text-nowrap dtSettings" style="width:100%">
            <thead>
                <tr>
                    <th>Domain Name</th>
                    <th class="text-center">Date Added</th>
                    <th class="text-center">Actions</th>
                </tr>
            </thead>
            <tbody>
                {foreach $domains as $domain}
                    <tr>
                        <td>{$domain.CustomDomain}</td>
                        <td class="text-center">{$domain.DateAdded|date_format:$globalDateFormat}</td>
                        <td class="text-right">
                            <a href="custom-domains.php?id={$domain.CustomDomainID}" class="btn btn-info btn-sm mr-2"><i
                                    class="fe fe-edit"></i>&nbsp;Edit</a>
                            {include file='partButtonDelete.tpl' itemID=$domain.CustomDomainID}
                        </td>
                    </tr>
                {/foreach}
            </tbody>
        </table>
    </div>
</div>

<input type="hidden" name="hidEditID" value="{$editID}" />

<script>
    $('#txtCustomDomain').blur(function () {
		if (($(this).val().length > 0) && ($(this).val().substr(0, 5) !== 'http:') && ($(this).val().substr(0, 5) !== 'https')) {
			$(this).val('https://' + $(this).val());
		}
	});
</script>