<?php
/**
 * @file template-tags.php
 *
 * Helper functions/template tags that can be used within template files.
 */


/**
 * Wrapper function around cmb_get_option
 *
 * @since 1.0.0
 *
 * @param  string  $key Options array key
 * @return mixed        Option value
 */
function wprpt_get_option( $key = '' ) {

    global $WPRPT_Options;
    return cmb_get_option( $WPRPT_Options->key, $key );

}


/**
 * Returns an array containing 1 image in the format [attachment id] => [image URL]
 *
 * @since 1.0.0
 *
 * @param none
 * @return mixed
 */
function wprpt_get_random_image() {

    $all_images = wprpt_get_option( 'images' );

	// Get out if the user didn't upload any random images
	if ( ! is_array($all_images) )
		return;

    $random_image = array_rand($all_images, 1);
    return $random_image;

}


/**
 * Returns the post types that should have a random image generated as the
 * post thumbnail.
 *
 * @since 1.0.0
 * 
 * @param none
 * @return mixed
 */
function wprpt_get_post_types() {

    $post_types = wprpt_get_option( 'selected_post_types' );
    return $post_types;

}